document.addEventListener("DOMContentLoaded", function () {
    obtenerImagenBanner();
});


function obtenerImagenBanner() {
    var baseURL = 'https://isotech.mx/escuela/constantino/public/licenciatura/getBanner';  

    axios.post(baseURL).then((response) => {
        if(response.status == 200){            
            const ImgenAsc = response.data;
            // if(ImgenAsc === undefined){
                // console.log("SIn dato", ImgenAsc);
                const bannerImgAsc = document.querySelectorAll('.bannerImgAsc');
                bannerImgAsc.forEach(function (divAsc) {               
                    // console.log(divAsc.style);
                    divAsc.style.background = " url("+ImgenAsc+") top center no-repeat ";
                    divAsc.style.backgroundSize = 'cover';
                    divAsc.style.width = '100%';  
                    divAsc.style.height = '100%';
                });
            // }
        }
    })
}

function compartir(title, text, url, img) {
    const shareData = {
        title: decodeURIComponent(title),
        url: decodeURIComponent(url)
    };
    if (navigator.share) {
        navigator.share(shareData)
            .then(() => console.log('Compartido exitosamente'))
            .catch((error) => console.log('Error al compartir', error));
    } else {
        // Fallback: copiar al portapapeles
        navigator.clipboard.writeText(decodeURIComponent(url))
            .then(() => alert('URL copiada al portapapeles'))
            .catch(() => alert('URL: ' + decodeURIComponent(url)));
    }
}

function abrirModalCompartir(url) {
    const decodedUrl = decodeURIComponent(url);
    document.getElementById('shareFacebook').href = `https://www.facebook.com/sharer/sharer.php?u=${encodeURIComponent(decodedUrl)}`;
    document.getElementById('shareTwitter').href = `https://twitter.com/intent/tweet?url=${encodeURIComponent(decodedUrl)}`;
    document.getElementById('shareWhatsApp').href = `https://wa.me/?text=${encodeURIComponent(decodedUrl)}`;
    document.getElementById('shareLinkedIn').href = `https://www.linkedin.com/sharing/share-offsite/?url=${encodeURIComponent(decodedUrl)}`;
}