<?php
require_once 'libs/controller.php';
class Moreinf extends Controller
{
    function __construct()
    {
        parent::__construct();
    }

    function render()
    {
        if (isset($_GET['id_lic'])) {
            $id = $_GET['id_lic'];
            // Get the main course details
            $licenciatura = $this->model->getLicenciaturaById($id);
            $this->view->licenciatura = $licenciatura;

            // Get related extra info cards for this specific course
            $moreinf = $this->model->getCardsByLicId($id);
            $this->view->moreinf = $moreinf;
        } else {
            // Fallback
            $moreinf = $this->model->getAllCards();
            $this->view->moreinf = $moreinf;
            $this->view->licenciatura = null;
        }

        $header = $this->model->getByEncabezado('Licenciaturas');
        $this->view->header = $header;

        $this->view->render('moreinf/index');
    }

    public function getBanner()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $banner = $this->model->getBanner();
            $imagenBanner = constant('ARCHIVOS') . $banner[0]->img;
            echo json_encode($imagenBanner);
        }
    }
}
