<?php
require_once 'libs/controller.php';
class MoreinfC extends Controller
{
    function __construct()
    {
        parent::__construct();
    }

    function render()
    {
        if (isset($_GET['id_ec'])) {
            $id = $_GET['id_ec'];
            // Get the main course details
            $curso = $this->model->getContinuaById($id);
            $this->view->curso = $curso;

            // Get related extra info cards for this specific course
            $moreinfC = $this->model->getCardsByEcId($id);
            $this->view->moreinfC = $moreinfC;
        } else {
            // Fallback for when no ID is passed (maybe show all or empty)
            $moreinfC = $this->model->getAllCards();
            $this->view->moreinfC = $moreinfC;
            $this->view->curso = null;
        }

        $header = $this->model->getByEncabezado('Maestrias');
        $this->view->header = $header;

        $this->view->render('moreinfC/index');
    }

    public function getBanner()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $banner = $this->model->getBanner();
            $imagenBanner = constant('ARCHIVOS') . $banner[0]->img;
            echo json_encode($imagenBanner);
        }
    }
}
