<?php
include_once 'models/clases/lic_datos.php';
include_once 'models/clases/encabezados.php';
include_once 'models/clases/imagen.php';
include_once 'models/clases/continuas.php';

class MoreinfCModel extends Model
{
    public function __construct()
    {
        parent::__construct();
    }

    public function getAllCards()
    {
        $items = [];
        try {
            $query = $this->db->connect()->query("SELECT * FROM ec_datos");
            while ($row = $query->fetch()) {
                $item = new lic_datos();

                $item->id_ec_datos = $row['id_ec_datos'];
                $item->id_ec = $row['id_ec'];
                $item->titulo = $row['titulo'];
                $item->descripcion = $row['descripcion'];
                $item->img_url = $row['img_url'];

                array_push($items, $item);
            }
            return $items;
        } catch (PDOException $th) {
            return [];
        }
    }

    public function getCardsByEcId($id)
    {
        $items = [];
        try {
            $query = $this->db->connect()->prepare("SELECT * FROM ec_datos WHERE id_ec = :id");
            $query->execute(['id' => $id]);
            while ($row = $query->fetch()) {
                $item = new lic_datos();

                $item->id_ec_datos = $row['id_ec_datos'];
                $item->id_ec = $row['id_ec'];
                $item->titulo = $row['titulo'];
                $item->descripcion = $row['descripcion'];
                $item->img_url = $row['img_url'];

                array_push($items, $item);
            }
            return $items;
        } catch (PDOException $th) {
            return [];
        }
    }

    public function getContinuaById($id)
    {
        $item = new Continuas();
        try {
            $query = $this->db->connect()->prepare("SELECT * FROM continua WHERE id_ec = :id");
            $query->execute(['id' => $id]);
            $row = $query->fetch();

            if ($row) {
                $item->id_ec = $row['id_ec'];
                $item->nom_ec = $row['nom_ec'];
                $item->descripcion = $row['descripcion'];
                $item->desc_detallada = $row['desc_detallada'];
                $item->revoe = $row['revoe'];
                $item->img_url = $row['img_url'];
                $item->pdf_url = $row['pdf_url'];
                return $item;
            }
            return null;
        } catch (PDOException $th) {
            return null;
        }
    }

    public function getByEncabezado($encabezado)
    {
        $item = new Encabezados();
        try {
            $query = $this->db->connect()->prepare(
                "SELECT * FROM encabezado WHERE encabezado = :encabezado AND id_usu = 1"
            );
            $query->execute(['encabezado' => $encabezado]);

            $row = $query->fetch();
            if ($row) {
                $item->id_en = $row['id_en'];
                $item->encabezado = $row['encabezado'];
                $item->descripcion = $row['descripcion'];
                $item->id_usu = $row['id_usu'];
                return $item;
            } else {
                return false;
            }
        } catch (PDOException $th) {
            return [];
        }
    }

    public function getBanner()
    {
        $items = [];
        try {
            $query = $this->db->connect()->query(
                "SELECT * FROM sliders WHERE id_usu=1 AND seccion='oferta-educativa' ORDER BY posicion ASC"
            );

            while ($row = $query->fetch()) {
                $item = new Imagen();
                $item->id_slider = $row['id_slider'];
                $item->img = $row['img'];
                $item->tit = $row['tit'];
                $item->descripcion = $row['descripcion'];
                $item->btn_name = $row['btn_name'];
                $item->link = $row['link'];
                $item->tUrl = $row['tUrl'];
                $item->posicion = $row['posicion'];
                $item->id_usu = $row['id_usu'];
                array_push($items, $item);
            }
            return $items;
        } catch (PDOException $e) {
            return [];
        }
    }
}
?>