<?php require 'views/templete/header.php'; ?>

<?php
// Get the course object and related items passed from the controller
$curso = isset($this->curso) ? $this->curso : null;
$related_items = isset($this->moreinfC) ? $this->moreinfC : [];

if ($curso) {
    $name = $curso->nom_ec;
    $desc_detallada = $curso->desc_detallada;
    if (empty($desc_detallada)) {
        $desc_detallada = $curso->descripcion;
    }
    $revoe = $curso->revoe;
    $imgp = $curso->img_url;
    $pdf = $curso->pdf_url;
    $id_ec = $curso->id_ec;
} else {
    $name = 'Curso no encontrado';
    $desc_detallada = 'No se encontró información para el curso solicitado.';
    $revoe = '';
    $imgp = '';
    $pdf = '';
    $id_ec = '';
}

$current_url = 'http://' . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'];
if ($curso && strpos($current_url, 'id_ec') === false) {
     $current_url .= '?id_ec=' . $curso->id_ec;
}
?>

<meta property="og:title" content="<?php echo htmlspecialchars($name); ?>">
<meta property="og:description" content="<?php echo htmlspecialchars($desc_detallada); ?>">
<meta property="og:image" content="<?php echo constant('URL') . htmlspecialchars($imgp); ?>">
<meta property="og:url" content="<?php echo $current_url; ?>">
<meta property="og:type" content="website">
<meta name="twitter:card" content="summary_large_image">

<style>
    /* Gradient Background applied to body for full coverage */
    body {
        background: linear-gradient(135deg, #001f4d 0%, #0043d4 100%) !important;
        background-attachment: fixed !important;
    }
    
    .premium-gradient-bg {
        background: transparent !important;
    }
    
    /* Card Styles */
    .detail-card {
        border: none;
        border-radius: 1rem;
        transition: transform 0.3s ease, box-shadow 0.3s ease;
        overflow: hidden;
    }
    .detail-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 1rem 3rem rgba(0,0,0,.15)!important;
    }
    .card-img-top-wrapper {
        min-height: 300px;
        height: 100%;
        overflow: hidden;
        position: relative;
    }
    .card-img-top-wrapper img {
        width: 100%;
        height: 100%;
        object-fit: cover;
        transition: transform 0.5s ease;
    }
    .detail-card:hover .card-img-top-wrapper img {
        transform: scale(1.03);
    }
    .badge-custom {
        background-color: var(--primary); 
        color: #fff;
        font-size: 0.9rem;
    }
    
    @media (max-width: 768px) {
        .card-img-top-wrapper {
            height: 250px;
        }
    }
</style>

<div class="container-fluid premium-gradient-bg py-5">
    <div class="container">
        
        <?php if ($curso): ?>
        <div class="row justify-content-center">
            <div class="col-lg-10">
                <div class="card detail-card bg-white shadow-lg mb-5 wow fadeInUp" data-wow-delay="0.1s">
                    <div class="row g-0">
                        <div class="col-lg-5">
                            <div class="card-img-top-wrapper">
                                <img src="<?php echo constant('ARCHIVOS') . htmlspecialchars($imgp); ?>" 
                                     alt="<?php echo htmlspecialchars($name); ?>">
                            </div>
                        </div>
                        <div class="col-lg-7">
                            <div class="card-body p-4 p-md-5 d-flex flex-column h-100 justify-content-center">
                                <?php if (!empty($revoe) && $revoe != 'undefined' && trim($revoe) !== '-'): ?>
                                <div class="mb-3">
                                    <span class="badge badge-custom rounded-pill py-2 px-3">
                                        RVOE: <?php echo htmlspecialchars($revoe); ?>
                                    </span>
                                </div>
                                <?php endif; ?>
                                
                                <h2 class="card-title fw-bold text-primary mb-4"><?php echo htmlspecialchars($name); ?></h2>
                                
                                <div class="card-text text-secondary mb-4 lead" style="line-height: 1.8; font-size: 1.15rem; font-weight: 500;">
                                    <?php echo nl2br(htmlspecialchars($desc_detallada)); ?>
                                </div>
                                
                                <?php if (!empty($pdf) && $pdf != 'undefined'): ?>
                                <div class="mt-4">
                                    <a href="<?php echo constant('ARCHIVOS') . $pdf; ?>" 
                                       class="btn btn-outline-danger rounded-pill px-4 fw-bold" 
                                       target="_blank">
                                        <i class="far fa-file-pdf me-2"></i> Descargar
                                    </a>
                                </div>
                                <?php endif; ?>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php else: ?>
            <div class="row justify-content-center">
                <div class="col-lg-8 text-center bg-light p-5 rounded shadow-sm">
                    <h3 class="text-muted">No se pudo cargar la información del curso.</h3>
                    <a href="<?php echo constant('URL'); ?>continua" class="btn btn-primary mt-3">Volver a Educación Continua</a>
                </div>
            </div>
        <?php endif; ?>

        <?php if (!empty($related_items)): ?>
            <div class="row g-4 justify-content-center mt-4">
                <?php foreach ($related_items as $item): ?>
                    <div class="col-lg-4 col-md-6 wow fadeInUp" data-wow-delay="0.1s">
                        <div class="service-item bg-white h-100 shadow-sm rounded-3 position-relative overflow-hidden">
                            <?php if(!empty($item->img_url)): ?>
                            <div class="overflow-hidden rounded-top" style="height: 200px;">
                                <img class="img-fluid w-100 h-100" 
                                     src="<?php echo constant('ARCHIVOS') . $item->img_url; ?>" 
                                     alt="<?php echo htmlspecialchars($item->titulo); ?>" 
                                     style="object-fit: cover;">
                            </div>
                            <?php endif; ?>
                            <div class="p-4">
                                <h5 class="mb-3 fw-bold text-dark">
                                    <?php echo htmlspecialchars($item->titulo); ?>
                                </h5>
                                <p class="text-muted mb-0">
                                    <?php echo htmlspecialchars($item->descripcion); ?>
                                </p>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>

    </div>
</div>

<?php require 'views/templete/whatsapp.php'; ?>
<?php require 'views/templete/footer.php'; ?>
<script src="<?php echo constant('URL') ?>assets/js/moreinfC.js"></script>